jQuery(document).ready(function(){
	$("#seccionDatosEmpresa_legend").on("click",function(){$("#seccionDatosEmpresa").toggle();});
	$("#seccionDatosSolicitante_legend").on("click",function(){$("#seccionDatosSolicitante").toggle();});
	$("#seccionRepresentanteLegal_legend").on("click",function(){$("#seccionRepresentanteLegal").toggle();});
	$("#seccionLugarTrabajos_legend").on("click",function(){$("#seccionLugarTrabajos").toggle();});
	$("#seccionDuracionTrabajos_legend").on("click",function(){$("#seccionDuracionTrabajos").toggle();});
	$("#seccionEstadoTramitacion_legend").on("click",function(){$("#seccionEstadoTramitacion").toggle();});	
	
	cargarCombos();
	
	$("#expFiltro").rup_table({
		url: "../expedientesFiltro",
		colNames: [
			$.rup.i18n.app.expedientes.expediente,
			$.rup.i18n.app.expedientes.plan,
			$.rup.i18n.app.expedientes.fecReg,
			$.rup.i18n.app.expedientes.cifNif,
			$.rup.i18n.app.expedientes.razonSocial,
			$.rup.i18n.app.expedientes.provTrabajo,
			$.rup.i18n.app.expedientes.munTrabajo,
			$.rup.i18n.app.expedientes.fInicioTrabajo,
			$.rup.i18n.app.expedientes.fase,
			$.rup.i18n.app.expedientes.tramite
		],
		colModel: [
			{ 	name: "idExpediente",
				label: "idExpediente",
			 	index: "id_Expediente",
				align: "right", 
				width: 130, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "planDescR"+ $.rup_utils.capitalizedLang(),
				label: "planDescR"+ $.rup_utils.capitalizedLang(),
			 	index: "DESCPLANR_"+ $.rup_utils.capitalizedLang(),
				align: "center", 
				width: 33, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fechReg010Excel", 
			 	label: "fecReg010",
			 	index: "fec_Reg_010",
				align: "left", 
				width: 100, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false,
				report: true,
				resizable: true, 
				sortable: true
			},	
			{ 	name: "nifEmpresa047",
				label: "nifEmpresa047",
			 	index: "nif_Empresa_047",
				align: "right", 
				width: 90,  
				resizable: true, 
				sortable: true
			},
			{ 	name: "razonSocial047", 
				label: "razonSocial047",
			 	index: "razon_Social_047",
				align: "left", 
				width: 200, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "provDo",
				label: "provDo",
			 	index: "prov_Do",
				align: "left", 
				width: 130, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "munDo", 
				label: "munDo",
			 	index: "mun_Do",
				align: "left", 
				width: 150, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fechIniTrabajo010Excel", 
			 	label: "fechIniTrabajo010",
			 	index: "f_Inicio_Trabajo_010",
				align: "left", 
				width: 110, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false,
				report: true,
				resizable: true, 
				sortable: true
			},	
			{ 	name: "fase" + $.rup_utils.capitalizedLang(), 
				label: "fase" + $.rup_utils.capitalizedLang(), 
			 	index: "fase_" + $.rup_utils.capitalizedLang(), 
				align: "left", 
				width: 200, 
				ruptype: "combo", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "tramite" + $.rup_utils.capitalizedLang(), 
				label: "tramite" + $.rup_utils.capitalizedLang(), 
			 	index: "tramite_" + $.rup_utils.capitalizedLang(),
				align: "left", 
				width: 200, 
				ruptype: "combo", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],
        model:"Ab03b10v00",
        usePlugins:[
			"formEdit",
	    	"feedback",
			"toolbar",
	    	"fluid",
	    	"filter",
	    	"report"
	     ],
		primaryKey: "idExpediente",
		sortname: "id_Expediente",
		sortorder: "asc",
		loadOnStartUp: false,
		feedback:{
			config:{
				block: false
			}
		},
		core:{
			operations:{
				"tramitacionExpediente": {
					name:	$.rup.i18n.app.botones.accederTramitacion,
					icon:	"rup-icon rup-icon-edit",
					enabled: function(){
						return !ab03bUtils.tabla.isEmptyGrid($("#expFiltro"));
					},
					callback: function(key, options){
						expediente_redirigirTramite();
					}
				}
			},
			showOperations:{
	    		"add": false,
	    		"edit": false,
	    		"delete": false,
	    		"clone": false
	    	}
    	},
        report: {
        	buttons: [{ 
              	'id': 'reports', 
              	'i18nCaption': $.rup.i18n.app.botones.informes, 
              	right: true,
        	    'buttons': [
        	        { 'i18nCaption': 'XLS', 'css': 'xls', 'url':'../expedientesFiltro/xlsReport?ultimoTramite='+$("#ultimoTramite").val() },
        	        { 'i18nCaption': 'XLSX', 'css': 'xls', 'url': '../expedientesFiltro/xlsxReport?ultimoTramite='+$("#ultimoTramite").val() },
        	        { 'i18nCaption': 'PDF', 'css': 'pdf', 'url': '../expedientesFiltro/pdfReport?ultimoTramite='+$("#ultimoTramite").val() }
        	    ]
              	}
        	]
        }
	}).ready(function(){
		$("[id='expFiltro_toolbar##reports']").css("float", "right");
		$("#expFiltro_toolbar").rup_toolbar({buttons:[]}).addClass("clsCustomToolbar");
	});

	/*   esto es para poder modificar el tooltip de la celda del plan en el grid
	$("#expFiltro").on("rupTable_beforeEditRow", function(){
			$("#expFiltro tr").each(function(i, elem){
				debugger;
				var oldTitle = elem.cells[1].attributes[3].textContent;			
			});
	})
	*/;
	
	$("#expFiltro").on("rupTable_beforeEditRow", 
		function(deleteOptions, selectedRow){
			if(ab03bUtils.form.validate($("#expFiltro_filter_form"))){	
	
				fila = $("#expFiltro").rup_grid('getGridParam', 'selrow');
				obj = $("#expFiltro").rup_grid('getRowData', fila);
	
				window.location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+obj.idExpediente;
	
				return false;
			} else {
				return false;
			}
		});	
	
	$("#expFiltro_filter_form").rup_validate({
		feedback:$("#expFiltro_feedback"),
		liveCheckingErrors: false,
		rules:{
			"idProv010":{digits:true},
			"idAno010":{digits:true},
			"id010":{digits:true},
			"fecRegDesde":{date:true, validacionFechas:true},
			"fecRegHasta":{date:true, validacionFechas:true},
			"numCalle047":{digits:true},
			"piso047":{digits:true},
			"cp047":{digits:true},
			"numeroTrabajo010":{digits:true},
			"pisoTrabajo010":{digits:true},
			"cpostalTrabajo010":{digits:true},
			"duracionDias010":{digits:true},
			"fecIniTrabDesde":{date:true, validacionFechasDetalle:true},
			"fecIniTrabHasta":{date:true, validacionFechasDetalle:true}
			}
	});	
	
	$("#expFiltro").on("rupTable_beforeFilter", 
	function(){
		if(ab03bUtils.form.validate($("#expFiltro_filter_form"))){	
			return true;
		} else {
			return false;
		}
	});	
	
	$("#ultimoTramite").on("click", function(){
		if ($("#ultimoTramite").is(":checked")){
			$("#filterEstado").show();
			$("#ultimoTramite").val('S');
		} else {
			$("#ultimoTramite").val('N');
			$("#filterEstado").hide();
			$("#id034Estado").rup_combo("select","");
			
		}
		
	});
});

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};

function cargarCombos(){
	cargarComboProvincia($('#provincia047'), "comboProvinciaTodas");

	$('#municipio047').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipio",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:"",
		parent:["provincia047"]
	});

	cargarComboProvincia($('#provinciaTrabajo010'), "comboProvincia");

	$('#municipTrabajo010').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipioTrabajo",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:"",
		parent:["provinciaTrabajo010"]
	});
	
	$('#id001Fase').rup_combo({
		source : "/ab03bAmiantoWar/ab03b01t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 320,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:""
	});	
	
	
	$('#id002Tramite').rup_combo({
		source : "/ab03bAmiantoWar/ab03b02t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["id001Fase"],
		blank:""
	});
	
	$('#id034Estado').rup_combo({
		source : "/ab03bAmiantoWar/ab03b34t00/comboEstado",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:""
	});
	
	$("#fecRegDesde").rup_date();
	$("#fecRegHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fecRegDesde").val();
		var fechaHasta=$("#fecRegHasta").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
	});	
	
	$("#fecIniTrabDesde_filter_table").rup_date();
	$("#fecIniTrabHasta_filter_table").rup_date();
	
	jQuery.validator.addMethod("validacionFechasDetalle", function(value, element, params) {
		var fechaDesde=$("#fecIniTrabDesde_filter_table").val();
		var fechaHasta=$("#fecIniTrabHasta_filter_table").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
	});
	
	$('#id008TipoPlan').rup_combo({
		source : "/ab03bAmiantoWar/ab03b08t00/comboTipoPlan",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:""
	});	
	
}

function cargarComboProvincia(combo, accion){
	// provincia solicitante
	combo.rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/"+accion,
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:""
	});
}

//Funcion limpiar
$('#expFiltro_filter_cleanLink').click(function(event){
	resetFiltro($("#expFiltro_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#expFiltro_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#expFiltro_feedback").rup_feedback("close");
	
	$("#expFiltro").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#expFiltro_filter_form")).remove();
});

//Funcion que redirige a la pestaña "Tramitacion" de un expediente
function expediente_redirigirTramite(){
		
	var fila = $("#expFiltro").rup_grid('getGridParam', 'selrow');
	var obj = $("#expFiltro").rup_grid('getRowData', fila);
	
	window.location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+obj.idExpediente +"?tab=2";
}
